// Get1ReadingDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Get1Reading.h"
#include "Get1ReadingDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGet1ReadingDlg dialog

CGet1ReadingDlg::CGet1ReadingDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGet1ReadingDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGet1ReadingDlg)
	m_reading = _T("");
	m_status = _T("");
	m_channel = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CGet1ReadingDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGet1ReadingDlg)
	DDX_Control(pDX, IDC_READ, m_readButton);
	DDX_Control(pDX, IDC_CLOSE, m_close);
	DDX_Text(pDX, IDC_READING, m_reading);
	DDX_Text(pDX, IDC_STATUS, m_status);
	DDX_Text(pDX, IDC_CHAN, m_channel);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CGet1ReadingDlg, CDialog)
	//{{AFX_MSG_MAP(CGet1ReadingDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_INIT, OnInit)
	ON_BN_CLICKED(IDC_READ, OnRead)
	ON_BN_CLICKED(IDC_CLOSE, OnClose)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGet1ReadingDlg message handlers

BOOL CGet1ReadingDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	// give our channel edit box an inital valid value
	m_channel = "101";
	UpdateData(FALSE);  // update the dialog
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CGet1ReadingDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CGet1ReadingDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CGet1ReadingDlg::OnInit() 
{
/*
  this application was written with MSVC++ 6 in Win98SE using
  KPCI-488, 2700 mainframe with B04 FW, 7700 card in Slot 1

  the IVI driver was version 2700-852B01

  Since the GPIB interface was used, the resource name in the InitWithOptions
  function was "GPIB0::16::INSTR"....instr at addr 16
  For RS-232 use: "ASRL1::INSTR"
  For TCP/IP (2701 only) use: "TCPIP::192.68.1.10::1394::SOCKET"

  The above are only examples of valid resource strings and may require
  modification based upon the specifics of your iterface/configuration

  NOTE for Ines PCMCIA card users:  your GPIB bus will be GPIB1 not GPIB0

  */

	// initialize the session
	ViStatus nErr;
	vi = new ViSession();
	char OPTIONSTRING[256] = "Simulate=0,RangeCheck=1,QueryInstrStatus=1,Cache=1";


nErr = KE2700_InitWithOptions("GPIB0::16::INSTR", VI_TRUE, VI_TRUE,OPTIONSTRING,vi);   

// below is an alternate means to init the session, but without
// the option string you have less control over the IVI driver

//nErr = KE2700_init("GPIB0::16::INSTR",VI_TRUE,VI_TRUE,vi);

if (nErr != 0)
{ DisplayError(*vi,nErr);}
else
{
	// enable our other buttons if no error
	m_readButton.EnableWindow(TRUE);
	m_close.EnableWindow(TRUE);
}

	
}  // end OnInit



void CGet1ReadingDlg::OnClose() 
{
	
	ViStatus nErr;
	nErr = KE2700_close (*vi);
	CDialog::DestroyWindow();  // tell the dialog to close down
}



void CGet1ReadingDlg::DisplayError(ViSession sesn, ViStatus nErr)
{
	ViStatus  error = VI_SUCCESS;
    ViChar    msgStr[256];  
    ViInt32   bufSize=256;

KE2700_error_message(*vi,nErr,msgStr);


	CString temp;
	temp.Format("Status = %s",msgStr);
	m_status.Format("%s",msgStr);
	UpdateData(FALSE);
//AfxMessageBox(temp);
//KE2700_GetAttributeViString(*vi, "", KE2700_ATTR_ERROR_QUEUE_NEXT, bufSize, msgStr);

}

void CGet1ReadingDlg::OnRead() 
{
	/*
	
	  this code section uses the pseudo-ViSession derived from the 
      KE2700_ChannelList function

      This is the recommended technique for control of channel
  */

ViStatus nErr;
double reading;

UpdateData(TRUE);  // get current channel data from the dialog


nErr = KE2700_ConfigureMeasurement(KE2700_ChannelList(*vi,m_channel),
								   KE2700_VAL_TEMPERATURE,KE2700_VAL_AUTO_RANGE_ON,1.0); 
if (nErr != 0)
{ DisplayError(*vi,nErr);}

nErr = KE2700_ConfigureTransducerType(KE2700_ChannelList(*vi,m_channel), KE2700_VAL_THERMOCOUPLE);

if (nErr != 0)
{ DisplayError(*vi,nErr);}

nErr = KE2700_ConfigureThermocouple (KE2700_ChannelList(*vi,m_channel),
									 KE2700_VAL_TEMP_TC_J,
									 KE2700_VAL_TC_REF_INTERNAL);
                                // the above configures to use the internal CJC
// only the 7700, 7706, 7708 or 7710 have an internal CJC
// if doing T/C measurements and have a card other than one of these
// you must use a simulated CJC (KE2700_VAL_TC_REF_SIMULATED) or external
// CJC (KE2700_VAL_TC_REF_EXTERNAL)
if (nErr != 0)
{ DisplayError(*vi,nErr);}

nErr = KE2700_Read (KE2700_ChannelList(*vi,m_channel), 5000, &reading);
if (nErr != 0)
{ DisplayError(*vi,nErr);}

m_reading.Format("%8.5f",reading);
UpdateData(FALSE);  // push our value out to the dialog
	
}
